﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SemanticMemory;

namespace Chatter
{
    public class Chatter
    {
        public delegate void ChatterSaysHandler(string text);

        public event ChatterSaysHandler ChatterSay;

        //ShortTermMemory STM;
        QuestionAnswerer QA;
        string resourcesPath;

        public Chatter(string resourceFilesPath)
        {
            resourcesPath = resourceFilesPath;
            //STM = new ShortTermMemory(7);
            QA = new QuestionAnswerer(resourcesPath);
        }

        public void SayToChatter(string textToSay)
        {
            string[] sentence = SentenceAnalyser.PrepareSentence(textToSay);
            SentenceType type = SentenceAnalyser.QualifySentence(sentence);
            switch (type)
            {
                case SentenceType.DefaultConversation:
                    FireChatterSayEvent(QA.AnswerDefaultConversation(sentence, resourcesPath));
                    break;
                //case SentenceType.SimpleSentence:
                //    STM.AddEntity(SentenceAnalyser.AnalyseSimpleSentence(sentence));
                //    break;
                //case SentenceType.WhQuestion:
                //    FireChatterSayEvent(QA.AnswerWhQuestion(sentence, resourcesPath));
                //    break;
                //case SentenceType.IsAQuestion:
                //    FireChatterSayEvent(QA.AnswerIsAQuestion(sentence));
                //    break;
                //case SentenceType.IsQuestion:
                //    FireChatterSayEvent(QA.AnswerIsQuestion(sentence));
                //    break;
                //case SentenceType.HasQuestion:
                //    FireChatterSayEvent(QA.AnswerHasQuestion(sentence, STM));
                //    break;
                case SentenceType.Order:
                    FireChatterSayEvent(QA.AnswerOrder(sentence, resourcesPath));
                    break;
            }
            //FireChatterSayEvent(SentenceAnalyser.QualifyComplexSentence(sentence[0], resourcesPath));
        }

        public void FireChatterSayEvent(string text)
        {
            if (ChatterSay != null)
            {
                ChatterSay(text);
            }
        }
    }
}
